FasdUAS 1.101.10       
  k           
  l              Accordance Script Library        4   A c c o r d a n c e   S c r i p t   L i b r a r y   	 

 	 l             Version 1.10.1b1      
 
 "   V e r s i o n   1 . 1 0 . 1 b 1 
   
  l           !  Created by Joe Weaks, 2012        6   C r e a t e d   b y   J o e   W e a k s ,   2 0 1 2    
  l               
  l           

This script's purpose is to be used as a script library for use in other scripting applications. 
To install the library, place this Accordance Script Library in:
~/Library/Scripts/

It does include handlers that allow it to be used as a template for creating Quicksilver and LaunchBar actions. It has a run handler that allows it to be launched from any scripting environment which will begin with a dialog box.

-- The core of the Accordance Script Library is the handler:
lookupAccordance(searchString, moduleType, whichModule, fieldType, inputFrom, outputTo, useCitationFormat, otherOptions)

-- This handler can be called from other environments using "load script", such as:

set accScript to load script alias "iMac HD:Users:MyHomeFolder:Library:Scripts:Accordance Script Library"

tell accScript to lookupAccordance("hope", "English Texts", 1, "Words", "Script", "accordanceWindow", false, "")

or 

tell accScript to lookupAccordance("John 11.35", "Scripture", "GNT-T", "Verses", "Script", "displayResult", true, "")

        
 T h i s   s c r i p t ' s   p u r p o s e   i s   t o   b e   u s e d   a s   a   s c r i p t   l i b r a r y   f o r   u s e   i n   o t h e r   s c r i p t i n g   a p p l i c a t i o n s .   
 T o   i n s t a l l   t h e   l i b r a r y ,   p l a c e   t h i s   A c c o r d a n c e   S c r i p t   L i b r a r y   i n : 
 ~ / L i b r a r y / S c r i p t s / 
 
 I t   d o e s   i n c l u d e   h a n d l e r s   t h a t   a l l o w   i t   t o   b e   u s e d   a s   a   t e m p l a t e   f o r   c r e a t i n g   Q u i c k s i l v e r   a n d   L a u n c h B a r   a c t i o n s .   I t   h a s   a   r u n   h a n d l e r   t h a t   a l l o w s   i t   t o   b e   l a u n c h e d   f r o m   a n y   s c r i p t i n g   e n v i r o n m e n t   w h i c h   w i l l   b e g i n   w i t h   a   d i a l o g   b o x . 
 
 - -   T h e   c o r e   o f   t h e   A c c o r d a n c e   S c r i p t   L i b r a r y   i s   t h e   h a n d l e r : 
 l o o k u p A c c o r d a n c e ( s e a r c h S t r i n g ,   m o d u l e T y p e ,   w h i c h M o d u l e ,   f i e l d T y p e ,   i n p u t F r o m ,   o u t p u t T o ,   u s e C i t a t i o n F o r m a t ,   o t h e r O p t i o n s ) 
 
 - -   T h i s   h a n d l e r   c a n   b e   c a l l e d   f r o m   o t h e r   e n v i r o n m e n t s   u s i n g   " l o a d   s c r i p t " ,   s u c h   a s : 
 
 s e t   a c c S c r i p t   t o   l o a d   s c r i p t   a l i a s   " i M a c   H D : U s e r s : M y H o m e F o l d e r : L i b r a r y : S c r i p t s : A c c o r d a n c e   S c r i p t   L i b r a r y " 
 
 t e l l   a c c S c r i p t   t o   l o o k u p A c c o r d a n c e ( " h o p e " ,   " E n g l i s h   T e x t s " ,   1 ,   " W o r d s " ,   " S c r i p t " ,   " a c c o r d a n c e W i n d o w " ,   f a l s e ,   " " ) 
 
 o r   
 
 t e l l   a c c S c r i p t   t o   l o o k u p A c c o r d a n c e ( " J o h n   1 1 . 3 5 " ,   " S c r i p t u r e " ,   " G N T - T " ,   " V e r s e s " ,   " S c r i p t " ,   " d i s p l a y R e s u l t " ,   t r u e ,   " " ) 
 
    
  l               
  l           + %-------------------------------------          J - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -   ! "
 ! l      # $   #    Property Settings  --    $  % % .     P r o p e r t y   S e t t i n g s     - - "  & '
 & l      ( )   (   These are just default settings. Normally this script's routine is called from another script or Service, providing its own property settings. Alter these property settings in the Script or Action or Service that is using the Script Library    )  * *   T h e s e   a r e   j u s t   d e f a u l t   s e t t i n g s .   N o r m a l l y   t h i s   s c r i p t ' s   r o u t i n e   i s   c a l l e d   f r o m   a n o t h e r   s c r i p t   o r   S e r v i c e ,   p r o v i d i n g   i t s   o w n   p r o p e r t y   s e t t i n g s .   A l t e r   t h e s e   p r o p e r t y   s e t t i n g s   i n   t h e   S c r i p t   o r   A c t i o n   o r   S e r v i c e   t h a t   i s   u s i n g   t h e   S c r i p t   L i b r a r y '  + ,
 + l      - .   - ? 9 See fuller documentation of the settings explained below    .  / / r   S e e   f u l l e r   d o c u m e n t a t i o n   o f   t h e   s e t t i n g s   e x p l a i n e d   b e l o w ,  0 1
 0 l            1  2 3
 2 j      4 0 
moduletype 
moduleType
 4 m      5 5  6 6  E n g l i s h   T o o l s 3  7 8
 7 l      9 :   9
 Options: {"Current Window", "Scripture", "English Texts", "Greek Texts", "Hebrew Texts", "English Tools", "Greek Tools", "Hebrew Tools", "Reference Tools", "General Tools", "Parallels", "User Tools", "User Notes", "Map", "Timeline", "Search All", "Save File"}    :  ; ;   O p t i o n s :   { " C u r r e n t   W i n d o w " ,   " S c r i p t u r e " ,   " E n g l i s h   T e x t s " ,   " G r e e k   T e x t s " ,   " H e b r e w   T e x t s " ,   " E n g l i s h   T o o l s " ,   " G r e e k   T o o l s " ,   " H e b r e w   T o o l s " ,   " R e f e r e n c e   T o o l s " ,   " G e n e r a l   T o o l s " ,   " P a r a l l e l s " ,   " U s e r   T o o l s " ,   " U s e r   N o t e s " ,   " M a p " ,   " T i m e l i n e " ,   " S e a r c h   A l l " ,   " S a v e   F i l e " } 8  < =
 < l            =  > ?
 > j     @ 0 whichmodule whichModule
 @ m      ?  A B
 A l      C D   C G A Options: {1, 2, 3, 4, 5, 6, 7, 8, 9, 0, "NRSVS", "NIV11", etc.}     D  E E    O p t i o n s :   { 1 ,   2 ,   3 ,   4 ,   5 ,   6 ,   7 ,   8 ,   9 ,   0 ,   " N R S V S " ,   " N I V 1 1 " ,   e t c . }   B  F G
 F l            G  H I
 H j     J 0 	fieldtype 	fieldType
 J m     K K  L L  D e f a u l t I  M N
 M l      O P   O s m Options: {"Default", "Words", "Verses"} -- ignored unless output is "accordanceWindow" in a scripture module    P  Q Q    O p t i o n s :   { " D e f a u l t " ,   " W o r d s " ,   " V e r s e s " }   - -   i g n o r e d   u n l e s s   o u t p u t   i s   " a c c o r d a n c e W i n d o w "   i n   a   s c r i p t u r e   m o d u l e N  R S
 R l            S  T U
 T j   	  V 0 outputto outputTo
 V m   	 
 W W  X X   a c c o r d a n c e W i n d o w U  Y Z
 Y l      [ \   [ q k Options: {"accordanceWindow", "returnResult", "pasteResult", "copyResult", "speakResult", "displayResult"}    \  ] ]    O p t i o n s :   { " a c c o r d a n c e W i n d o w " ,   " r e t u r n R e s u l t " ,   " p a s t e R e s u l t " ,   " c o p y R e s u l t " ,   " s p e a k R e s u l t " ,   " d i s p l a y R e s u l t " } Z  ^ _
 ^ l            _  ` a
 ` j     b &0 usecitationformat useCitationFormat
 b m    
 boovfals a  c d
 c l      e f   e J D Options: {true, false} -- ignored if outputTo is "accordanceWindow"    f  g g    O p t i o n s :   { t r u e ,   f a l s e }   - -   i g n o r e d   i f   o u t p u t T o   i s   " a c c o r d a n c e W i n d o w " d  h i
 h l            i  j k
 j j     l 0 otheroptions otherOptions
 l m     m m  n n   k  o p
 o l      q r   q "  a place for obscure options    r  s s 8   a   p l a c e   f o r   o b s c u r e   o p t i o n s p  t u
 t l            u  v w
 v l            w  x y
 x l            y  z {
 z l      | }   | + %-------------------------------------    }  ~ ~ J - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - {   
  l           !  User Settings Explained --        6   U s e r   S e t t i n g s   E x p l a i n e d   - -    
  l           + %-------------------------------------        J - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -    
  l           
These are properties that allow the user to customize where to send the output (outputTo), which type of Accordance module to use (moduleType), which module of that type (whichModule) and how to format the results if not being displayed in Accordance (useCitationFormat).

-- outputTo
This property indicates what to do with the result. 
Options to choose from:
a. "accordanceWindow" = displays the result in a new Accordance window of type specified in moduleType. 
(This option brings Accordance to the front and performs the search in an Accordance window. All the other options leave Accordance in the background and work in the front application, but they are limited to looking up verse references.)
b. "returnResult" = returns the scripture text ready for further processing in a scripting environment such as Services
c. "pasteResult" = pastes scripture text in front app using clipboard. Used for Quicksilver actions and other scripts. Do not use with Services which have their own replace text mechanism. Use returnResult to let the Service function replace text. 
d. "copyResult" = places the result of the search on the clipboard
e. "speakResult" = speaks the results (only modern language texts; voice name can be placed in otherOptions)
f. "displayResult" = displays scripture text in a HUD or Dialog Box in the app that called the action (Uses Quicksilver or Launchbar HUD if available). To display inside Accordance, use "accordanceWindow"

-- moduleType
Designate the type of module to search in Accordance ("English Texts", "Greek Texts", "Map", "English Tools", etc.). Note that Tools and Texts use the plural form, as is the practice in Accordance menus.
Options to choose from:
"Current Window" -- finds result in the current window open in Accordance ("Recycles" the front window). A new default window should open if one is not already present.
"Scripture" = used to indicate the user-sorted list of texts that includes all English, Greek and Hebrew. Used when not displaying the result in an Accordance Window
"English Texts" = finds result in an English Text
"Greek Texts" = finds result in a Greek Text
"Hebrew Texts" = finds result in a Hebrew Text
"English Tools" = finds result in a new Accordance English Tool window
"Greek Tools" = finds result in a new Accordance Greek Tool window.
"Hebrew Tools" = finds result in a new Accordance English Tool window.
"Reference Tools" = finds result in a new Accordance Reference tool window
"General Tools" = finds result in a new Accordance General Tool window
"Parallels" = finds result in a new Accordance Parallel window
"User Tools" = finds result in a new Accordance User Tool window
"User Notes" = finds result in a new Accordance User Notes window
"Map" = finds result in a new Accordance Map window
"Timeline" = finds result in a new Accordance Timeline window
"Search All" = finds result in a new Accordance Search All window
"Save file" = opens a saved Accordance Tab/Window and finds the result in that save window. The file path is specified in otherOptions. Leave whichModule set to 1 and Field set to Default as they are ignored.

-- fieldType
"Verses" = searches verses in a new Accordance scripture text window; this is only option when not displaying the result in Accordance (ie. outputTo is set to "accordanceWindow").
"Words" = displays words in a new Accordance scripture text window
"Default" = will not adjust the default field type. Used with all non-scripture text Accordance windows such as Tools.
(Due to limitations scripting Accordance, fieldType is actually ignored for all Accordance module types other than Scripture windows. For example, you can not change the field of a Greek Tool to English gloss. In some instances, you can adjust the default search "Field" for that window type to achieve the desired results. You must be savvy about sending a scripture reference to a Reference Tool, and a place name to a Map window, etc., in order to avoid errors. Be sure you're sending a search string in the appropriate font layout & language for that search field. )

-- whichModule
Specify which module to use for the results
1, 2, 0 = setting to an integer will pull the corresponding scripture from that position in the module list in Accordance
"NRSVS, NIV11, CEB," = setting to a scripture module short name will use that module (the short module name must be as displayed in an Accordance File/New menu)

-- searchString
Will be a valid verse reference for verse searches and can be any text string for other searches

-- useCitationFormat
Choose whether to use the Citation format when not displaying the result in an Accordance Window
true = uses the Citation format 
false = uses a standard Verses format
Note that true and false are not wrapped in quotation marks. This setting is ignored when outputTo is set to "accordanceWindow". It is handy for othe outputs (ie. outputTo: "pasteResult", "displayResult", "speakResult" or "returnResult").  You can customize the Citation format in Accordance/Preferences/Citation.

-- otherOptions
A place for obscure options; often empty and unused
Can specify voice name {"Victoria", "Fred", ...} if output is "speakResult"
Can provide the file path when moduleType is "Save File". Format is: "Macintosh HD:Users:MyUsername:FileName"
Can also indicate copy and paste text results from an Accordance Window (see below)

-------------------------------------------------

-- Note:
Note that most properties are given inside quotation marks.
Only certain configurations are supported or just make sense or function together. Only Scripture Verses can be searched without displaying in Accordance. Some options will be ignored if not applicable. (eg. useCitationFormat does not apply when displaying the output in an Accordance window. The fieldType of Verses or Words is ignored when not displaying a Scripture module in Accordance.)

Possible configurations:
outputTo: "returnResult" / "displayResult" / "pasteResult" / "speakResult" / "copyResult"
moduletype: "Scripture"
fieldType: "Verses"
whichModule: 1 / 2 / 3 /  / "NRSV" / "GNT-T" / 
useCitationFormat: true / false

outputTo: "accordanceWindow"
moduleType: "English Texts" / "Greek Texts" / "Hebrew Texts" 
(Avoid using "Scripture" when displaying in an Accordance Window. The best practice is to indicate which group the text comes from.)
fieldType: "Verses" / "Words"
whichModule: 1 / 2 / 3 /  / "NRSV" / "GNT-T" / 

outputTo: "accordanceWindow"
moduleType: "User Notes" / "User Tools" / "General Tools" / "English Tools" / "Greek Tools" / "Hebrew Tools" / "Reference Tools" / "Map"
fieldType: "Default"
whichModule: 1 / 2 / 3 /   / "PhotoGuide" / "UBS Lexicon" / "BDB" / "WBC-NT" / "OT in NT" / "Beige" / 

outputTo: "accordanceWindow"
moduleType: "Current Window" / "Timeline" / "Search All"
fieldType: "Default"
whichModule: 1

-- Tip: If there is a particular Tool where you often want to ad hoc search a particular field from wherever you are, use the "Save File":
outputTo: "accordanceWindow"
moduleType: "Save File"
fieldType: "Default"
whichModule: 1
otherOptions: "Macintosh HD:Users:MyHomeFolder:My Save File"
       7 
 T h e s e   a r e   p r o p e r t i e s   t h a t   a l l o w   t h e   u s e r   t o   c u s t o m i z e   w h e r e   t o   s e n d   t h e   o u t p u t   ( o u t p u t T o ) ,   w h i c h   t y p e   o f   A c c o r d a n c e   m o d u l e   t o   u s e   ( m o d u l e T y p e ) ,   w h i c h   m o d u l e   o f   t h a t   t y p e   ( w h i c h M o d u l e )   a n d   h o w   t o   f o r m a t   t h e   r e s u l t s   i f   n o t   b e i n g   d i s p l a y e d   i n   A c c o r d a n c e   ( u s e C i t a t i o n F o r m a t ) . 
 
 - -   o u t p u t T o 
 T h i s   p r o p e r t y   i n d i c a t e s   w h a t   t o   d o   w i t h   t h e   r e s u l t .   
 O p t i o n s   t o   c h o o s e   f r o m : 
 a .   " a c c o r d a n c e W i n d o w "   =   d i s p l a y s   t h e   r e s u l t   i n   a   n e w   A c c o r d a n c e   w i n d o w   o f   t y p e   s p e c i f i e d   i n   m o d u l e T y p e .   
 ( T h i s   o p t i o n   b r i n g s   A c c o r d a n c e   t o   t h e   f r o n t   a n d   p e r f o r m s   t h e   s e a r c h   i n   a n   A c c o r d a n c e   w i n d o w .   A l l   t h e   o t h e r   o p t i o n s   l e a v e   A c c o r d a n c e   i n   t h e   b a c k g r o u n d   a n d   w o r k   i n   t h e   f r o n t   a p p l i c a t i o n ,   b u t   t h e y   a r e   l i m i t e d   t o   l o o k i n g   u p   v e r s e   r e f e r e n c e s . ) 
 b .   " r e t u r n R e s u l t "   =   r e t u r n s   t h e   s c r i p t u r e   t e x t   r e a d y   f o r   f u r t h e r   p r o c e s s i n g   i n   a   s c r i p t i n g   e n v i r o n m e n t   s u c h   a s   S e r v i c e s 
 c .   " p a s t e R e s u l t "   =   p a s t e s   s c r i p t u r e   t e x t   i n   f r o n t   a p p   u s i n g   c l i p b o a r d .   U s e d   f o r   Q u i c k s i l v e r   a c t i o n s   a n d   o t h e r   s c r i p t s .   D o   n o t   u s e   w i t h   S e r v i c e s   w h i c h   h a v e   t h e i r   o w n   r e p l a c e   t e x t   m e c h a n i s m .   U s e   r e t u r n R e s u l t   t o   l e t   t h e   S e r v i c e   f u n c t i o n   r e p l a c e   t e x t .   
 d .   " c o p y R e s u l t "   =   p l a c e s   t h e   r e s u l t   o f   t h e   s e a r c h   o n   t h e   c l i p b o a r d 
 e .   " s p e a k R e s u l t "   =   s p e a k s   t h e   r e s u l t s   ( o n l y   m o d e r n   l a n g u a g e   t e x t s ;   v o i c e   n a m e   c a n   b e   p l a c e d   i n   o t h e r O p t i o n s ) 
 f .   " d i s p l a y R e s u l t "   =   d i s p l a y s   s c r i p t u r e   t e x t   i n   a   H U D   o r   D i a l o g   B o x   i n   t h e   a p p   t h a t   c a l l e d   t h e   a c t i o n   ( U s e s   Q u i c k s i l v e r   o r   L a u n c h b a r   H U D   i f   a v a i l a b l e ) .   T o   d i s p l a y   i n s i d e   A c c o r d a n c e ,   u s e   " a c c o r d a n c e W i n d o w " 
 
 - -   m o d u l e T y p e 
 D e s i g n a t e   t h e   t y p e   o f   m o d u l e   t o   s e a r c h   i n   A c c o r d a n c e   ( " E n g l i s h   T e x t s " ,   " G r e e k   T e x t s " ,   " M a p " ,   " E n g l i s h   T o o l s " ,   e t c . ) .   N o t e   t h a t   T o o l s   a n d   T e x t s   u s e   t h e   p l u r a l   f o r m ,   a s   i s   t h e   p r a c t i c e   i n   A c c o r d a n c e   m e n u s . 
 O p t i o n s   t o   c h o o s e   f r o m : 
 " C u r r e n t   W i n d o w "   - -   f i n d s   r e s u l t   i n   t h e   c u r r e n t   w i n d o w   o p e n   i n   A c c o r d a n c e   ( " R e c y c l e s "   t h e   f r o n t   w i n d o w ) .   A   n e w   d e f a u l t   w i n d o w   s h o u l d   o p e n   i f   o n e   i s   n o t   a l r e a d y   p r e s e n t . 
 " S c r i p t u r e "   =   u s e d   t o   i n d i c a t e   t h e   u s e r - s o r t e d   l i s t   o f   t e x t s   t h a t   i n c l u d e s   a l l   E n g l i s h ,   G r e e k   a n d   H e b r e w .   U s e d   w h e n   n o t   d i s p l a y i n g   t h e   r e s u l t   i n   a n   A c c o r d a n c e   W i n d o w 
 " E n g l i s h   T e x t s "   =   f i n d s   r e s u l t   i n   a n   E n g l i s h   T e x t 
 " G r e e k   T e x t s "   =   f i n d s   r e s u l t   i n   a   G r e e k   T e x t 
 " H e b r e w   T e x t s "   =   f i n d s   r e s u l t   i n   a   H e b r e w   T e x t 
 " E n g l i s h   T o o l s "   =   f i n d s   r e s u l t   i n   a   n e w   A c c o r d a n c e   E n g l i s h   T o o l   w i n d o w 
 " G r e e k   T o o l s "   =   f i n d s   r e s u l t   i n   a   n e w   A c c o r d a n c e   G r e e k   T o o l   w i n d o w . 
 " H e b r e w   T o o l s "   =   f i n d s   r e s u l t   i n   a   n e w   A c c o r d a n c e   E n g l i s h   T o o l   w i n d o w . 
 " R e f e r e n c e   T o o l s "   =   f i n d s   r e s u l t   i n   a   n e w   A c c o r d a n c e   R e f e r e n c e   t o o l   w i n d o w 
 " G e n e r a l   T o o l s "   =   f i n d s   r e s u l t   i n   a   n e w   A c c o r d a n c e   G e n e r a l   T o o l   w i n d o w 
 " P a r a l l e l s "   =   f i n d s   r e s u l t   i n   a   n e w   A c c o r d a n c e   P a r a l l e l   w i n d o w 
 " U s e r   T o o l s "   =   f i n d s   r e s u l t   i n   a   n e w   A c c o r d a n c e   U s e r   T o o l   w i n d o w 
 " U s e r   N o t e s "   =   f i n d s   r e s u l t   i n   a   n e w   A c c o r d a n c e   U s e r   N o t e s   w i n d o w 
 " M a p "   =   f i n d s   r e s u l t   i n   a   n e w   A c c o r d a n c e   M a p   w i n d o w 
 " T i m e l i n e "   =   f i n d s   r e s u l t   i n   a   n e w   A c c o r d a n c e   T i m e l i n e   w i n d o w 
 " S e a r c h   A l l "   =   f i n d s   r e s u l t   i n   a   n e w   A c c o r d a n c e   S e a r c h   A l l   w i n d o w 
 " S a v e   f i l e "   =   o p e n s   a   s a v e d   A c c o r d a n c e   T a b / W i n d o w   a n d   f i n d s   t h e   r e s u l t   i n   t h a t   s a v e   w i n d o w .   T h e   f i l e   p a t h   i s   s p e c i f i e d   i n   o t h e r O p t i o n s .   L e a v e   w h i c h M o d u l e   s e t   t o   1   a n d   F i e l d   s e t   t o   D e f a u l t   a s   t h e y   a r e   i g n o r e d . 
 
 - -   f i e l d T y p e 
 " V e r s e s "   =   s e a r c h e s   v e r s e s   i n   a   n e w   A c c o r d a n c e   s c r i p t u r e   t e x t   w i n d o w ;   t h i s   i s   o n l y   o p t i o n   w h e n   n o t   d i s p l a y i n g   t h e   r e s u l t   i n   A c c o r d a n c e   ( i e .   o u t p u t T o   i s   s e t   t o   " a c c o r d a n c e W i n d o w " ) . 
 " W o r d s "   =   d i s p l a y s   w o r d s   i n   a   n e w   A c c o r d a n c e   s c r i p t u r e   t e x t   w i n d o w 
 " D e f a u l t "   =   w i l l   n o t   a d j u s t   t h e   d e f a u l t   f i e l d   t y p e .   U s e d   w i t h   a l l   n o n - s c r i p t u r e   t e x t   A c c o r d a n c e   w i n d o w s   s u c h   a s   T o o l s . 
 ( D u e   t o   l i m i t a t i o n s   s c r i p t i n g   A c c o r d a n c e ,   f i e l d T y p e   i s   a c t u a l l y   i g n o r e d   f o r   a l l   A c c o r d a n c e   m o d u l e   t y p e s   o t h e r   t h a n   S c r i p t u r e   w i n d o w s .   F o r   e x a m p l e ,   y o u   c a n   n o t   c h a n g e   t h e   f i e l d   o f   a   G r e e k   T o o l   t o   E n g l i s h   g l o s s .   I n   s o m e   i n s t a n c e s ,   y o u   c a n   a d j u s t   t h e   d e f a u l t   s e a r c h   " F i e l d "   f o r   t h a t   w i n d o w   t y p e   t o   a c h i e v e   t h e   d e s i r e d   r e s u l t s .   Y o u   m u s t   b e   s a v v y   a b o u t   s e n d i n g   a   s c r i p t u r e   r e f e r e n c e   t o   a   R e f e r e n c e   T o o l ,   a n d   a   p l a c e   n a m e   t o   a   M a p   w i n d o w ,   e t c . ,   i n   o r d e r   t o   a v o i d   e r r o r s .   B e   s u r e   y o u ' r e   s e n d i n g   a   s e a r c h   s t r i n g   i n   t h e   a p p r o p r i a t e   f o n t   l a y o u t   &   l a n g u a g e   f o r   t h a t   s e a r c h   f i e l d .   ) 
 
 - -   w h i c h M o d u l e 
 S p e c i f y   w h i c h   m o d u l e   t o   u s e   f o r   t h e   r e s u l t s 
 1 ,   2 , &   0   =   s e t t i n g   t o   a n   i n t e g e r   w i l l   p u l l   t h e   c o r r e s p o n d i n g   s c r i p t u r e   f r o m   t h a t   p o s i t i o n   i n   t h e   m o d u l e   l i s t   i n   A c c o r d a n c e 
 " N R S V S ,   N I V 1 1 ,   C E B , & "   =   s e t t i n g   t o   a   s c r i p t u r e   m o d u l e   s h o r t   n a m e   w i l l   u s e   t h a t   m o d u l e   ( t h e   s h o r t   m o d u l e   n a m e   m u s t   b e   a s   d i s p l a y e d   i n   a n   A c c o r d a n c e   F i l e / N e w   m e n u ) 
 
 - -   s e a r c h S t r i n g 
 W i l l   b e   a   v a l i d   v e r s e   r e f e r e n c e   f o r   v e r s e   s e a r c h e s   a n d   c a n   b e   a n y   t e x t   s t r i n g   f o r   o t h e r   s e a r c h e s 
 
 - -   u s e C i t a t i o n F o r m a t 
 C h o o s e   w h e t h e r   t o   u s e   t h e   C i t a t i o n   f o r m a t   w h e n   n o t   d i s p l a y i n g   t h e   r e s u l t   i n   a n   A c c o r d a n c e   W i n d o w 
 t r u e   =   u s e s   t h e   C i t a t i o n   f o r m a t   
 f a l s e   =   u s e s   a   s t a n d a r d   V e r s e s   f o r m a t 
 N o t e   t h a t   t r u e   a n d   f a l s e   a r e   n o t   w r a p p e d   i n   q u o t a t i o n   m a r k s .   T h i s   s e t t i n g   i s   i g n o r e d   w h e n   o u t p u t T o   i s   s e t   t o   " a c c o r d a n c e W i n d o w " .   I t   i s   h a n d y   f o r   o t h e   o u t p u t s   ( i e .   o u t p u t T o :   " p a s t e R e s u l t " ,   " d i s p l a y R e s u l t " ,   " s p e a k R e s u l t "   o r   " r e t u r n R e s u l t " ) .     Y o u   c a n   c u s t o m i z e   t h e   C i t a t i o n   f o r m a t   i n   A c c o r d a n c e / P r e f e r e n c e s / C i t a t i o n . 
 
 - -   o t h e r O p t i o n s 
 A   p l a c e   f o r   o b s c u r e   o p t i o n s ;   o f t e n   e m p t y   a n d   u n u s e d 
 C a n   s p e c i f y   v o i c e   n a m e   { " V i c t o r i a " ,   " F r e d " ,   . . . }   i f   o u t p u t   i s   " s p e a k R e s u l t " 
 C a n   p r o v i d e   t h e   f i l e   p a t h   w h e n   m o d u l e T y p e   i s   " S a v e   F i l e " .   F o r m a t   i s :   " M a c i n t o s h   H D : U s e r s : M y U s e r n a m e : F i l e N a m e " 
 C a n   a l s o   i n d i c a t e   c o p y   a n d   p a s t e   t e x t   r e s u l t s   f r o m   a n   A c c o r d a n c e   W i n d o w   ( s e e   b e l o w ) 
 
 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 
 - -   N o t e : 
 N o t e   t h a t   m o s t   p r o p e r t i e s   a r e   g i v e n   i n s i d e   q u o t a t i o n   m a r k s . 
 O n l y   c e r t a i n   c o n f i g u r a t i o n s   a r e   s u p p o r t e d   o r   j u s t   m a k e   s e n s e   o r   f u n c t i o n   t o g e t h e r .   O n l y   S c r i p t u r e   V e r s e s   c a n   b e   s e a r c h e d   w i t h o u t   d i s p l a y i n g   i n   A c c o r d a n c e .   S o m e   o p t i o n s   w i l l   b e   i g n o r e d   i f   n o t   a p p l i c a b l e .   ( e g .   u s e C i t a t i o n F o r m a t   d o e s   n o t   a p p l y   w h e n   d i s p l a y i n g   t h e   o u t p u t   i n   a n   A c c o r d a n c e   w i n d o w .   T h e   f i e l d T y p e   o f   V e r s e s   o r   W o r d s   i s   i g n o r e d   w h e n   n o t   d i s p l a y i n g   a   S c r i p t u r e   m o d u l e   i n   A c c o r d a n c e . ) 
 
 P o s s i b l e   c o n f i g u r a t i o n s : 
 o u t p u t T o :   " r e t u r n R e s u l t "   /   " d i s p l a y R e s u l t "   /   " p a s t e R e s u l t "   /   " s p e a k R e s u l t "   /   " c o p y R e s u l t " 
 m o d u l e t y p e :   " S c r i p t u r e " 
 f i e l d T y p e :   " V e r s e s " 
 w h i c h M o d u l e :   1   /   2   /   3   /   &   /   " N R S V "   /   " G N T - T "   /   & 
 u s e C i t a t i o n F o r m a t :   t r u e   /   f a l s e 
 
 o u t p u t T o :   " a c c o r d a n c e W i n d o w " 
 m o d u l e T y p e :   " E n g l i s h   T e x t s "   /   " G r e e k   T e x t s "   /   " H e b r e w   T e x t s "   
 ( A v o i d   u s i n g   " S c r i p t u r e "   w h e n   d i s p l a y i n g   i n   a n   A c c o r d a n c e   W i n d o w .   T h e   b e s t   p r a c t i c e   i s   t o   i n d i c a t e   w h i c h   g r o u p   t h e   t e x t   c o m e s   f r o m . ) 
 f i e l d T y p e :   " V e r s e s "   /   " W o r d s " 
 w h i c h M o d u l e :   1   /   2   /   3   /   &   /   " N R S V "   /   " G N T - T "   /   & 
 
 o u t p u t T o :   " a c c o r d a n c e W i n d o w " 
 m o d u l e T y p e :   " U s e r   N o t e s "   /   " U s e r   T o o l s "   /   " G e n e r a l   T o o l s "   /   " E n g l i s h   T o o l s "   /   " G r e e k   T o o l s "   /   " H e b r e w   T o o l s "   /   " R e f e r e n c e   T o o l s "   /   " M a p " 
 f i e l d T y p e :   " D e f a u l t " 
 w h i c h M o d u l e :   1   /   2   /   3   /     &   /   " P h o t o G u i d e "   /   " U B S   L e x i c o n "   /   " B D B "   /   " W B C - N T "   /   " O T   i n   N T "   /   " B e i g e "   /   & 
 
 o u t p u t T o :   " a c c o r d a n c e W i n d o w " 
 m o d u l e T y p e :   " C u r r e n t   W i n d o w "   /   " T i m e l i n e "   /   " S e a r c h   A l l " 
 f i e l d T y p e :   " D e f a u l t " 
 w h i c h M o d u l e :   1 
 
 - -   T i p :   I f   t h e r e   i s   a   p a r t i c u l a r   T o o l   w h e r e   y o u   o f t e n   w a n t   t o   a d   h o c   s e a r c h   a   p a r t i c u l a r   f i e l d   f r o m   w h e r e v e r   y o u   a r e ,   u s e   t h e   " S a v e   F i l e " : 
 o u t p u t T o :   " a c c o r d a n c e W i n d o w " 
 m o d u l e T y p e :   " S a v e   F i l e " 
 f i e l d T y p e :   " D e f a u l t " 
 w h i c h M o d u l e :   1 
 o t h e r O p t i o n s :   " M a c i n t o s h   H D : U s e r s : M y H o m e F o l d e r : M y   S a v e   F i l e " 
    
  l               
  l           + %-------------------------------------        J - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -    
  l           %  End User Settings  Explained--        >   E n d   U s e r   S e t t i n g s     E x p l a i n e d - -    
  l           + %-------------------------------------        J - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -    
  l               
  l           + %-------------------------------------        J - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -    
  l           X R The remainder of the script should only be altered if you know what you're doing.           T h e   r e m a i n d e r   o f   t h e   s c r i p t   s h o u l d   o n l y   b e   a l t e r e d   i f   y o u   k n o w   w h a t   y o u ' r e   d o i n g .    
  l           + %-------------------------------------        J - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -    
  l               
  l           9 3 Use this run handler when run as a compiled script        f   U s e   t h i s   r u n   h a n d l e r   w h e n   r u n   a s   a   c o m p i l e d   s c r i p t    
  i      
  I      
 .aevtoappnull      ****
  J          
  k     <     
  l               
  l           ) # Brings up dialog box to enter text        F   B r i n g s   u p   d i a l o g   b o x   t o   e n t e r   t e x t    
  I      
 .sysodlogaskr        ****
  m           " E n t e r   s e a r c h   t e x t   
 
dtxt
  m           J o h n   1 1 : 3 5      
  r    
  
  n      
  1   	 
 
ttxt
  l   	 
  1    	
 
rslt    
  o       0 searchstring searchString    
  l             
  l         - ' Gets selected text using the clipboard        N   G e t s   s e l e c t e d   t e x t   u s i n g   t h e   c l i p b o a r d    
  l         !  doKeyCombination("c", "x")        6   d o K e y C o m b i n a t i o n ( " c " ,   " x " )    
  l          	 delay .2           d e l a y   . 2    
  l         ( " set searchString to the clipboard        D   s e t   s e a r c h S t r i n g   t o   t h e   c l i p b o a r d    
  l             
  r      
  m           S c r i p t
  o       0 	inputfrom 	inputFrom    
  r    9  
  I    7  $0 lookupaccordance lookupAccordance    
  o     0 searchstring searchString    
  o     0 
moduletype 
moduleType    
  o     0 whichmodule whichModule    
  o    # 0 	fieldtype 	fieldType    
  o   # $ 0 	inputfrom 	inputFrom  
 o   $ ) 0 outputto outputTo 
 o   ) . &0 usecitationformat useCitationFormat 
 o   . 3 0 otheroptions otherOptions    
  o       0 	theresult 	theResult  
 L   : <
 o   : ; 0 	theresult 	theResult    	
 l           	 


 l     
   / ) Handler to serve as a Quicksilver action   
  R   H a n d l e r   t o   s e r v e   a s   a   Q u i c k s i l v e r   a c t i o n 
 w      
 i    
 I     
 .DAEDopnt****       utxt
 o       0 searchstring searchString  
 k     ) 
 r     
 m        Q u i c k s i l v e r
 o       0 	inputfrom 	inputFrom 
 I    ) $0 lookupaccordance lookupAccordance  
 o     0 searchstring searchString  !"
! o    ~~ 0 
moduletype 
moduleType" #$
# o    }} 0 whichmodule whichModule$ %&
% o    || 0 	fieldtype 	fieldType& '(
' o    {{ 0 	inputfrom 	inputFrom( )*
) o    zz 0 outputto outputTo* +,
+ o     yy &0 usecitationformat useCitationFormat, -x
- o     %ww 0 otheroptions otherOptionsx                                                                                        daed  alis      Macintosh HD               8H+   0QQuicksilver.app                                                I@sR          	                Applications    $      s      0Q {    7Macintosh HD:Users: joew: Applications: Quicksilver.app      Q u i c k s i l v e r . a p p    M a c i n t o s h   H D  'Users/joew/Applications/Quicksilver.app   /       ./
. l     vutv  u  t  / 01
0 l     s23s  2 - ' Handler to serve as a Launchbar action   3 44 N   H a n d l e r   t o   s e r v e   a s   a   L a u n c h b a r   a c t i o n1 56
5 w      78
7 i    9:
9 I      r;qr 0 
handle_string  ; <p
< o      oo 0 searchstring searchStringp  q  
: k     /== >?
> r     @A
@ m     BB CC  L a u n c h B a r
A o      nn 0 	inputfrom 	inputFrom? DE
D l   mFGm  F * $tell application "LaunchBar" to hide   G HH H t e l l   a p p l i c a t i o n   " L a u n c h B a r "   t o   h i d eE IJ
I I   	lKk
l .GURLGURLnull     TEXT
K m    LL MM   x - l a u n c h b a r : h i d ek  J Nj
N I   
 /iOhi $0 lookupaccordance lookupAccordanceO PQ
P o    gg 0 searchstring searchStringQ RS
R o    ff 0 
moduletype 
moduleTypeS TU
T o    ee 0 whichmodule whichModuleU VW
V o    dd 0 	fieldtype 	fieldTypeW XY
X o    cc 0 	inputfrom 	inputFromY Z[
Z o    !bb 0 outputto outputTo[ \]
\ o   ! &aa &0 usecitationformat useCitationFormat] ^`
^ o   & +__ 0 otheroptions otherOptions`  h  j  8v                                                                                      @ alis       Macintosh HD               8H+  
LaunchBar.app                                                                A                 $               
 L a u n c h B a r . a p p    M a c i n t o s h   H D  Applications/LaunchBar.app  /       6 _`
_ l     ^]\^  ]  \  ` ab
a l     [ZY[  Z  Y  b cd
c l     XefX  e + %-------------------------------------   f gg J - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -d hi
h l     WjkW  j   Accordance Handlers --   k ll .   A c c o r d a n c e   H a n d l e r s   - -i mn
m l     VopV  o + %-------------------------------------   p qq J - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -n rs
r l     UTSU  T  S  s tu
t i    !vw
v I      RxQR .0 getmodulenamefromlist getModuleNameFromListx yP
y o      OO 0 modulenumber moduleNumberP  Q  
w k     zz {|
{ l     N}~N  } U O returns module short name corresponding to the order in the list in Accordance   ~     r e t u r n s   m o d u l e   s h o r t   n a m e   c o r r e s p o n d i n g   t o   t h e   o r d e r   i n   t h e   l i s t   i n   A c c o r d a n c e| 
 r     
 I     MLKM 0 
getmodulelist 
getModuleListL  K  
 o      JJ 0 
modulelist 
moduleList 
 r    
 n    
 4   	 I
I 
cobj
 o   
 HH 0 modulenumber moduleNumber
 o    	GG 0 
modulelist 
moduleList
 o      FF 0 
modulename 
moduleName 
 l   EDCE  D  C   
 l   BB   ' ! Remove leading control character     B   R e m o v e   l e a d i n g   c o n t r o l   c h a r a c t e r 
 l   AA   _ Y if text 1 thru 1 of moduleName is "" then set moduleName to text 2 thru -1 of moduleName        i f   t e x t   1   t h r u   1   o f   m o d u l e N a m e   i s   " "   t h e n   s e t   m o d u l e N a m e   t o   t e x t   2   t h r u   - 1   o f   m o d u l e N a m e 
 r    
 n   
 I    @?@ .0 removeextracharacters removeExtraCharacters >
 o    == 0 
modulename 
moduleName>  ?  
  f    
 o      << 0 
modulename 
moduleName 
 l   ;:9;  :  9   8
 L    
 o    77 0 
modulename 
moduleName8  u 
 l     6546  5  4   
 i   " %
 I      3213 0 
getmodulelist 
getModuleList2  1  
 k      
 l     00   4 . returns a list of all Accordance text modules     \   r e t u r n s   a   l i s t   o f   a l l   A c c o r d a n c e   t e x t   m o d u l e s 
 O    
 r    
 I   	/.-
/ .AccdVerL****       ****.  -  
 o      ,, 0 	theresult 	theResult
 m                                                                                       ACC0  alis    ^  Macintosh HD               8H+  Accordance.app                                                 MNdhIa          	                Applications    $      h      )Macintosh HD:Applications: Accordance.app     A c c o r d a n c e . a p p    M a c i n t o s h   H D  Applications/Accordance.app   /    +
 L   
 
 o   
 ** 0 	theresult 	theResult+   
 l     )(')  (  '   
 i   & )
 I      &%& $0 getscripturetext getScriptureText 
 o      $$ 0 
modulename 
moduleName 
 o      ## 0 
textreference 
textReference "
 o      !!  0 citationformat citationFormat"  %  
 k      
 l          3 - returns scripture text from the named module     Z   r e t u r n s   s c r i p t u r e   t e x t   f r o m   t h e   n a m e d   m o d u l e 
 l        Y S setting citationFormat to true will use the custom citation format from Accordance        s e t t i n g   c i t a t i o n F o r m a t   t o   t r u e   w i l l   u s e   t h e   c u s t o m   c i t a t i o n   f o r m a t   f r o m   A c c o r d a n c e 
 O    
 r    
 I   

 .AccdTxRf****       ****
 J    	 
 o     0 
modulename 
moduleName 
 o     0 
textreference 
textReference 
 o      0 citationformat citationFormat    
 o       0 	theresult 	theResult
 m                                                                                       ACC0  alis    ^  Macintosh HD               8H+  Accordance.app                                                 MNdhIa          	                Applications    $      h      )Macintosh HD:Applications: Accordance.app     A c c o r d a n c e . a p p    M a c i n t o s h   H D  Applications/Accordance.app   /    
 L    
 o     0 	theresult 	theResult   
 l            
 i   * -
 I       0 checkenglish checkEnglish 
 o       0 
modulename 
moduleName    
 k      
 l        6 0 returns true if the module is an English module     `   r e t u r n s   t r u e   i f   t h e   m o d u l e   i s   a n   E n g l i s h   m o d u l e 
 O    
 r    

 I   


 .AccdIsEg****       ****
 J     
 o    

 0 
modulename 
moduleName    
 o      		 0 	theresult 	theResult
 m                                                                                       ACC0  alis    ^  Macintosh HD               8H+  Accordance.app                                                 MNdhIa          	                Applications    $      h      )Macintosh HD:Applications: Accordance.app     A c c o r d a n c e . a p p    M a c i n t o s h   H D  Applications/Accordance.app   /    
 L    
 o     0 	theresult 	theResult   
 l            
 l        + %-------------------------------------     J - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -  
  l        ' ! Accordance Lookup script library     B   A c c o r d a n c e   L o o k u p   s c r i p t   l i b r a r y 
 l        b \ This versatile routine can be called from an external script using the load script command.    		    T h i s   v e r s a t i l e   r o u t i n e   c a n   b e   c a l l e d   f r o m   a n   e x t e r n a l   s c r i p t   u s i n g   t h e   l o a d   s c r i p t   c o m m a n d . 


 i   . 1

 I         $0 lookupaccordance lookupAccordance 
 o       0 
search_string 
search_String 
 o       0 module_type module_Type 
 o       0 which_module which_Module 
 o       0 
field_type 
field_Type 
 o       0 
input_from 
input_From 
 o       0 	output_to 	output_To 
 o       (0 use_citationformat use_CitationFormat 
 o       0 
other_options 
other_Options    

 k      
 l     !"  !      " ##     $%
$ Z    &'(
& C    )*
) o      0 	output_to 	output_To
* m    ++ ,,   a c c o r d a n c e W i n d o w
' k    -- ./
. I    0 $0 showinaccordance showInAccordance0 12
1 o     0 
search_string 
search_String2 34
3 o    	 0 module_type module_Type4 56
5 o   	 
 0 which_module which_Module6 78
7 o   
  0 
field_type 
field_Type8 9
9 o     0 
other_options 
other_Options    / :
: L    ;
; l   <
< 1    
 
rslt        
( k   == >?
> l   @A  @ : 4 use Accordance Apple event calls to obtain the text   A BB h   u s e   A c c o r d a n c e   A p p l e   e v e n t   c a l l s   t o   o b t a i n   t h e   t e x t? CD
C l   EF  E b \ ignores module_Type which should be set to "English/Greek/Hebrew Texts" or just "Scripture"   F GG    i g n o r e s   m o d u l e _ T y p e   w h i c h   s h o u l d   b e   s e t   t o   " E n g l i s h / G r e e k / H e b r e w   T e x t s "   o r   j u s t   " S c r i p t u r e "D HI
H l   JK  J : 4 ignores field_Type, which should be set to "Verses"   K LL h   i g n o r e s   f i e l d _ T y p e ,   w h i c h   s h o u l d   b e   s e t   t o   " V e r s e s "I MN
M l         N OP
O l   QR  Q C = Remove any non-alphanumeric characters from end of reference   R SS z   R e m o v e   a n y   n o n - a l p h a n u m e r i c   c h a r a c t e r s   f r o m   e n d   o f   r e f e r e n c eP TU
T l   VW  V A ; mostly for the purpose of removing a final carriage return   W XX v   m o s t l y   f o r   t h e   p u r p o s e   o f   r e m o v i n g   a   f i n a l   c a r r i a g e   r e t u r nU YZ
Y r    [\
[ I    ] .0 removeextracharacters removeExtraCharacters] ^
^ o     0 
search_string 
search_String    
\ o       0 
search_string 
search_StringZ _`
_ l           ` ab
a l     cd  c G A Looks up the name of the module to use if a number is designated   d ee    L o o k s   u p   t h e   n a m e   o f   t h e   m o d u l e   t o   u s e   i f   a   n u m b e r   i s   d e s i g n a t e db fg
f Q     :hi
h k   # 1jj kl
k r   # (mn
m c   # &op
o o   # $ 0 which_module which_Module
p m   $ %
 
long
n o       0 which_module which_Modulel q
q r   ) 1rs
r I   ) /t .0 getmodulenamefromlist getModuleNameFromListt u
u o   * + 0 which_module which_Module    
s o       0 which_module which_Module  
i R      
 .ascrerr ****       ****      g vw
v l  ; ;      w xy
x l  ; ;z{  z #  Get the text from Accordance   { || :   G e t   t h e   t e x t   f r o m   A c c o r d a n c ey }~
} O  ; K
 r   ? J
 I  ? H
 .AccdTxRf****       ****
 J   ? D 
 o   ? @ 0 which_module which_Module 
 o   @ A 0 
search_string 
search_String 
 o   A B (0 use_citationformat use_CitationFormat    
 o       0 	theresult 	theResult
 m   ; <                                                                                  ACC0  alis    ^  Macintosh HD               8H+  Accordance.app                                                 MNdhIa          	                Applications    $      h      )Macintosh HD:Applications: Accordance.app     A c c o r d a n c e . a p p    M a c i n t o s h   H D  Applications/Accordance.app   /   ~ 
 l  L L       
 Z   L
 =  L O
 o   L M 0 	output_to 	output_To
 m   M N   p a s t e R e s u l t
 k   R ^ 
 l  R R       
 I   R Y 0 	pastetext 	pasteText 
 o   S T 0 	theresult 	theResult 
 o   T U 0 
input_from 
input_From     
 L   Z \
 m   Z [
 boovtrue 
 l  ] ]         
 =  a d
 o   a b 0 	output_to 	output_To
 m   b c   c o p y R e s u l t 
 k   g w 
 l  g g       
 I  g l
 .JonspClpnull     ****
 o   g h 0 	theresult 	theResult   
 I  m r
 .sysodelanull  nmbr
 m   m n ?ə   
 L   s u
 m   s t
 boovtrue 
 l  v v         
 =  z 
 o   z { 0 	output_to 	output_To
 m   { ~   s p e a k R e s u l t 
 k     
 I     0 
minimumvolume 
minimumVolume 
 m     2     
 Q    
 k     
 l      8 2 in case a voice name is given in the otherOptions     d   i n   c a s e   a   v o i c e   n a m e   i s   g i v e n   i n   t h e   o t h e r O p t i o n s 
 I   
 .sysottosnull     TEXT
 o     0 	theresult 	theResult 
 
VOIC
 o     0 
other_options 
other_Options    
 R      
 .ascrerr ****       ****    
 I   
 .sysottosnull     TEXT
 o     0 	theresult 	theResult   
 L    
 m    
 boovtrue 
 l            
 =   
 o     0 	output_to 	output_To
 m       d i s p l a y R e s u l t 
 k     
 Z    
 =   
 o     0 
input_from 
input_From
 m       Q u i c k s i l v e r
 w    
 O   
 I   
 .DAEDlargnull    utxt
 o     0 	theresult 	theResult  
 m                                                                                      daed  alis      Macintosh HD               8H+   0QQuicksilver.app                                                I@sR          	                Applications    $      s      0Q {    7Macintosh HD:Users: joew: Applications: Quicksilver.app      Q u i c k s i l v e r . a p p    M a c i n t o s h   H D  'Users/joew/Applications/Quicksilver.app   /                                                                                        daed  alis      Macintosh HD               8H+   0QQuicksilver.app                                                I@sR          	                Applications    $      s      0Q {    7Macintosh HD:Users: joew: Applications: Quicksilver.app      Q u i c k s i l v e r . a p p    M a c i n t o s h   H D  'Users/joew/Applications/Quicksilver.app   /       
 =   
 o     0 
input_from 
input_From
 m       L a u n c h B a r 
 w    
 O   
 I   ~}
~ .odlbltyp****       ****
 o    || 0 	theresult 	theResult}  
 m    v                                                                                      @ alis       Macintosh HD               8H+  
LaunchBar.app                                                                A                 $               
 L a u n c h B a r . a p p    M a c i n t o s h   H D  Applications/LaunchBar.app  /       v                                                                                      @ alis       Macintosh HD               8H+  
LaunchBar.app                                                                A                 $               
 L a u n c h B a r . a p p    M a c i n t o s h   H D  Applications/LaunchBar.app  /         
 l    
 I    {z{ 0 
displayresult 
displayResult y
 o    xx 0 	theresult 	theResulty  z    U O if input_From is "Script" or "Service" then -- will display dialog anywhere			        i f   i n p u t _ F r o m   i s   " S c r i p t "   o r   " S e r v i c e "   t h e n   - -   w i l l   d i s p l a y   d i a l o g   a n y w h e r e 	 	 	 
 L    
 m    w
w boovtrue v
 l   utsu  t  s  v   	

	 =   
 o    rr 0 	output_to 	output_To
 m    

   r e t u r n R e s u l t
 q
 L   
 o   pp 0 	theresult 	theResultq      % o
 l nmln  m  l  o   
 l     kjik  j  i   
 l     hh   + %-------------------------------------     J - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 l     gg   S M This handler displays a search string in Accordance using a specified module        T h i s   h a n d l e r   d i s p l a y s   a   s e a r c h   s t r i n g   i n   A c c o r d a n c e   u s i n g   a   s p e c i f i e d   m o d u l e 
 i   2 5 !
  I      f"ef $0 showinaccordance showInAccordance" #$
# o      dd 0 
asearchstring 
aSearchString$ %&
% o      cc 0 amoduletype aModuleType& '(
' o      bb 0 awhichmodule aWhichModule( )*
) o      aa 0 
afieldtype 
aFieldType* +`
+ o      __ 0 
aotheroptions 
aOtherOptions`  e  
! k    ,, -.
- l     ^]\^  ]  \  . /0
/ l     [12[  1 Z T Correct old module type or tool name references with plural forms found in New menu   2 33    C o r r e c t   o l d   m o d u l e   t y p e   o r   t o o l   n a m e   r e f e r e n c e s   w i t h   p l u r a l   f o r m s   f o u n d   i n   N e w   m e n u0 45
4 Q     ?67Z
6 Z   689YX
8 G    *:;
: G    <=
< l   >WV
> =   ?@
? n    AB
A 7   UCD
U 
ctxt
C m    
TT
D m    
SS
B o    RR 0 amoduletype aModuleType
@ m    EE FF  T o o lW  V  
= l   GQP
G =   HI
H o    OO 0 amoduletype aModuleType
I m    JJ KK  P a r a l l e lQ  P  
; l   (LNM
L =   (MN
M n    &OP
O 7   &LQR
L 
ctxt
Q m     "KK
R m   # %JJ
P o    II 0 amoduletype aModuleType
N m   & 'SS TT  T e x tN  M  
9 r   - 2UV
U b   - 0WX
W o   - .HH 0 amoduletype aModuleType
X m   . /YY ZZ  s
V o      GG 0 amoduletype aModuleTypeY  X  
7 R      FED
F .ascrerr ****       ****E  D  Z  5 [\
[ l  @ @CBAC  B  A  \ ]^
] Q   @ U_`a
_ l  C Hbcd
b r   C Hef
e c   C Fgh
g o   C D@@ 0 awhichmodule aWhichModule
h m   D E?
? 
long
f o      >> 0 awhichmodule aWhichModulec ; 5 coerce the data type of aWhichModule to avoid errors   d ii j   c o e r c e   t h e   d a t a   t y p e   o f   a W h i c h M o d u l e   t o   a v o i d   e r r o r s
` R      =<;
= .ascrerr ****       ****<  ;  
a r   P Ujk
j c   P Slm
l o   P Q:: 0 awhichmodule aWhichModule
m m   Q R9
9 
TEXT
k o      88 0 awhichmodule aWhichModule^ no
n l  V V7657  6  5  o pq
p O  V `rs
r I  Z _432
4 .miscactvnull  null3  2  
s m   V Wtt                                                                                  ACC0  alis    ^  Macintosh HD               8H+  Accordance.app                                                 MNdhIa          	                Applications    $      h      )Macintosh HD:Applications: Accordance.app     A c c o r d a n c e . a p p    M a c i n t o s h   H D  Applications/Accordance.app   /   q uv
u I  a f1w0
1 .sysodelanull  nmbr
w m   a bxx ?ə0  v yz
y O   g{|
{ k   k}} ~
~ l  k k/.-/  .  -   
 Q   k 
 r   n x
 4   n v,
, 
prcs
 m   r u  
 a c o r d
 o      ++ 0 
accordprocess 
accordProcess
 R      *)(
* .ascrerr ****       ****)  (  
 Q    
 r    
 4    '
' 
prcs
 m       A c c o r d
 o      && 0 
accordprocess 
accordProcess
 R      %$#
% .ascrerr ****       ****$  #  
 r    
 4    "
" 
prcs
 m       A c c o r d a n c e
 o      !! 0 
accordprocess 
accordProcess 
 l            
 O   
 k    
 l          
 Z   
 E   
 J     
 m       S c r i p t u r e 
 m       E n g l i s h   T e x t s 
 m       G r e e k   T e x t s 
 m       H e b r e w   T e x t s  
 o     0 amoduletype aModuleType
 k    
 l          
 Z   B
 =   
 o     0 amoduletype aModuleType
 m       S c r i p t u r e
 k    
 I   
 .prcskprsnull    utxt
 m       n 
 
faal
 J     
 m    
 eMdsKcmd     
 I   
 .sysodelanull  nmbr
 m     ?ٙ
   
 l   
    
   
 l   		   ' ! Change from module 1 to 2 thru 9     B   C h a n g e   f r o m   m o d u l e   1   t o   2   t h r u   9 
 Z   

 l   
 E   
 J     
 m      
 m      
 m      
 m      
 m        
 m      
 m      
 m     	 
 m        
 o     0 awhichmodule aWhichModule    
 k    
 l       
 control #        c o n t r o l   # 
 I  
 .prcskprsnull    utxt
 l   
 c    
 o     0 awhichmodule aWhichModule
 m    
 
TEXT     
 
faal
 J     
  m    
 eMdsKctl           
 l           
 k  B 
 I @
 .prcsclicuiel     uiel
 n  <
 4  7<
 
menI
 o  :; 0 awhichmodule aWhichModule
 n  7	

	 4  27
 
menE
 m  56 

 n  2

 4  -2
 
menI
 o  01 0 amoduletype aModuleType

 n  -
 4  (-
 
menE
 m  +, 
 n  (
 4  !(
 
menI
 m  $'   N e w
 n  !
 4  !
 
menE
 m    
 n  
 4  
 
mbri
 m     F i l e
 4  
 
mbar
 m       
  l AA         !"
! l CC      " #$
# l CC      $ %&
% Z  C'()
' = CH*+
* o  CD 0 
afieldtype 
aFieldType
+ m  DG,, --  V e r s e s
( k  Kh.. /0
/ l KK12  1 C = Remove any non-alphanumeric characters from end of reference   2 33 z   R e m o v e   a n y   n o n - a l p h a n u m e r i c   c h a r a c t e r s   f r o m   e n d   o f   r e f e r e n c e0 45
4 l KK67  6 A ; mostly for the purpose of removing a final carriage return   7 88 v   m o s t l y   f o r   t h e   p u r p o s e   o f   r e m o v i n g   a   f i n a l   c a r r i a g e   r e t u r n5 9:
9 r  KS;<
; n KQ=>
= I  LQ? .0 removeextracharacters removeExtraCharacters? @
@ o  LM 0 
asearchstring 
aSearchString    
>  f  KL
< o       0 
asearchstring 
aSearchString: AB
A l TT      B CD
C I TfEF
 .prcskprsnull    utxt
E m  TWGG HH  vF I
 
faal
I J  ZbJJ KL
K m  Z]
 eMdsKcmdL M
M m  ]`
 eMdsKctl    D NO
N l ggPQ  P u o click menu item "Verses" of menu 1 of menu item "Search For" of menu 1 of menu bar item "Search" of menu bar 1   Q RR    c l i c k   m e n u   i t e m   " V e r s e s "   o f   m e n u   1   o f   m e n u   i t e m   " S e a r c h   F o r "   o f   m e n u   1   o f   m e n u   b a r   i t e m   " S e a r c h "   o f   m e n u   b a r   1O S
S l gg        ) TU
T = kpVW
V o  kl 0 
afieldtype 
aFieldType
W m  loXX YY 
 W o r d sU Z
Z I s[\
 .prcskprsnull    utxt
[ m  sv]] ^^  w\ _
 
faal
_ J  y`` ab
a m  y|
 eMdsKcmdb c
c m  |
 eMdsKctl        & de
d l       e f
f l          gh
g = ij
i o   0 amoduletype aModuleType
j m  kk ll  C u r r e n t   W i n d o wh mn
m k  oo pq
p l       q rs
r l tu  t E ? a left arrow and then a tab reliably highlights the search box   u vv ~   a   l e f t   a r r o w   a n d   t h e n   a   t a b   r e l i a b l y   h i g h l i g h t s   t h e   s e a r c h   b o xs wx
w I y
 .prcskprsnull    utxt
y 1  
 
spac  x z{
z I |
 .prcskcodnull    long
| m   {  { }~
} I 
 .prcskprsnull    utxt
 1  
 
tab   ~ 
 l        
 l    U O or, a space will bring cursor to the Search Box if it is currently in the text        o r ,   a   s p a c e   w i l l   b r i n g   c u r s o r   t o   t h e   S e a r c h   B o x   i f   i t   i s   c u r r e n t l y   i n   t h e   t e x t 
 l      keystroke space         k e y s t r o k e   s p a c e 
 l        
 l    ^ X or, adding two semicolon strokes ensures the search box is hilighted in a Search window        o r ,   a d d i n g   t w o   s e m i c o l o n   s t r o k e s   e n s u r e s   t h e   s e a r c h   b o x   i s   h i l i g h t e d   i n   a   S e a r c h   w i n d o w 
 l    ( "keystroke ";" using {command down}     D k e y s t r o k e   " ; "   u s i n g   { c o m m a n d   d o w n } 
 l     	delay 0.2      d e l a y   0 . 2 
 l    ( "keystroke ";" using {command down}     D k e y s t r o k e   " ; "   u s i n g   { c o m m a n d   d o w n } 
 l        
 l    ] W or, adding this next line ensures the cursor is in the search box in a Map or Timeline        o r ,   a d d i n g   t h i s   n e x t   l i n e   e n s u r e s   t h e   c u r s o r   i s   i n   t h e   s e a r c h   b o x   i n   a   M a p   o r   T i m e l i n e 
 l    ) # keystroke "f" using {command down}     F   k e y s t r o k e   " f "   u s i n g   { c o m m a n d   d o w n } 
 l         n 
 = 
 o   0 amoduletype aModuleType
 m     T i m e l i n e 
 k   
 I 
 .prcsclicuiel     uiel
 n  
 4  
 
menI
 o   0 amoduletype aModuleType
 n  
 4  
 
menE
 m   
 n  
 4  
 
menI
 m     N e w
 n  
 4  
 
menE
 m  ~~ 
 n  
 4  }
} 
mbri
 m     F i l e
 4  |
| 
mbar
 m  {{    
 I zy
z .sysodelanull  nmbr
 m   ?      y   
 I x
x .prcskprsnull    utxt
 m     f wv
w 
faal
 J   u
 m  t
t eMdsKcmdu  v   s
 l rqpr  q  p  s   
 = 
 o  oo 0 amoduletype aModuleType
 m     M a p 
 k  Q 
 I 7nm
n .prcsclicuiel     uiel
 n  3
 4  .3l
l 
menI
 o  12kk 0 awhichmodule aWhichModule
 n  .
 4  ).j
j 
menE
 m  ,-ii 
 n  )
 4  $)h
h 
menI
 o  '(gg 0 amoduletype aModuleType
 n  $
 4  $f
f 
menE
 m  "#ee 
 n  
 4  d
d 
menI
 m     N e w
 n  
 4  c
c 
menE
 m  bb 
 n  
 4  a
a 
mbri
 m       F i l e
 4  `
` 
mbar
 m  
__ m   
 l 88^]\^  ]  \   
 I 8?[Z
[ .sysodelanull  nmbr
 m  8; ?      Z   	

	 I @OY
Y .prcskprsnull    utxt
 m  @C

   f XW
X 
faal
 J  FK V
 m  FIU
U eMdsKcmdV  W  
 T
 l PPSRQS  R  Q  T   
 = TY
 o  TUPP 0 amoduletype aModuleType
 m  UX   S e a r c h   A l l 
 I \ON
O .prcsclicuiel     uiel
 n  \
 4  zM
M 
menI
 o  }~LL 0 amoduletype aModuleType
 n  \z 
 4  uzK!
K 
menE
! m  xyJJ 
  n  \u"#
" 4  nuI$
I 
menI
$ m  qt%% &&  N e w
# n  \n'(
' 4  inH)
H 
menE
) m  lmGG 
( n  \i*+
* 4  biF,
F 
mbri
, m  eh-- ..  F i l e
+ 4  \bE/
E 
mbar
/ m  `aDD N   01
0 = 23
2 o  CC 0 amoduletype aModuleType
3 m  44 55  S a v e   F i l e1 6B
6 k  77 89
8 l A@?A  @  ?  9 :;
: O <=
< I >>=
> .aevtodocnull      alis
> 4  <?
< 
alis
? o  ;; 0 
aotheroptions 
aOtherOptions=  
= m  @@                                                                                  MACS  alis    t  Macintosh HD               8H+  
Finder.app                                                     B          	                CoreServices    $      ͒      6Macintosh HD:System: Library: CoreServices: Finder.app   
 F i n d e r . a p p    M a c i n t o s h   H D  &System/Library/CoreServices/Finder.app  /   ; A:
A l 9879  8  7  :  B  
 k  BB CD
C l 6EF6  E ( " aModuleType is a tool or Parallel   F GG D   a M o d u l e T y p e   i s   a   t o o l   o r   P a r a l l e lD HI
H l 5435  4  3  I J2
J I 1K0
1 .prcsclicuiel     uiel
K n  LM
L 4  /N
/ 
menI
N o  .. 0 awhichmodule aWhichModule
M n  OP
O 4  -Q
- 
menE
Q m  ,, 
P n  RS
R 4  +T
+ 
menI
T o  ** 0 amoduletype aModuleType
S n  UV
U 4  )W
) 
menE
W m  (( 
V n  XY
X 4  'Z
' 
menI
Z m  [[ \\  N e w
Y n  ]^
] 4  &_
& 
menE
_ m  %% 
^ n  `a
` 4  $b
$ 
mbri
b m  cc dd  F i l e
a 4  #e
# 
mbar
e m  "" 0  2   fg
f l ! !       g hi
h I j
 .sysodelanull  nmbr
j m  kk ?ə  i lm
l l       m no
n I p
 .prcskprsnull    utxt
p o   0 
asearchstring 
aSearchString  o qr
q I s
 .sysodelanull  nmbr
s m  tt ?ٙ  r uv
u l       v wx
w I y
 .prcskprsnull    utxt
y o  
 
ret   x z{
z l 
  
    { |}
| l ~  ~ @ : Extra return in case the "New zone added" dialog comes up     t   E x t r a   r e t u r n   i n   c a s e   t h e   " N e w   z o n e   a d d e d "   d i a l o g   c o m e s   u p} 
 I 
	

 .sysodelanull  nmbr
 m   ?ٙ	   
 I 
 .prcskprsnull    utxt
 o  
 
ret    
 l        
 l          
 Z  
 E 
 J  
 
 m     c o p y R e s u l t 
 m     p a s t e R e s u l t 
 m     r e t u r n R e s u l t  
 o  
 0 
aotheroptions 
aOtherOptions
 k   
 l    S M Clunky, but the following code can be used to copy results to the clipboard         C l u n k y ,   b u t   t h e   f o l l o w i n g   c o d e   c a n   b e   u s e d   t o   c o p y   r e s u l t s   t o   t h e   c l i p b o a r d   
 l    ^ X from inside an Accordance Window. It places the insertion point in the result text pane        f r o m   i n s i d e   a n   A c c o r d a n c e   W i n d o w .   I t   p l a c e s   t h e   i n s e r t i o n   p o i n t   i n   t h e   r e s u l t   t e x t   p a n e 
 l    8 2 then selects all text and copies to the clipboard     d   t h e n   s e l e c t s   a l l   t e x t   a n d   c o p i e s   t o   t h e   c l i p b o a r d 
 l        
 l      ** Important** --      &   * *   I m p o r t a n t * *   - -   
 l    R L This UI scripting function will error if the results are too large to copy.        T h i s   U I   s c r i p t i n g   f u n c t i o n   w i l l   e r r o r   i f   t h e   r e s u l t s   a r e   t o o   l a r g e   t o   c o p y . 
 l    K E Make sure the Context is set to 0, not All Context or Auto Context,         M a k e   s u r e   t h e   C o n t e x t   i s   s e t   t o   0 ,   n o t   A l l   C o n t e x t   o r   A u t o   C o n t e x t ,   
 l    b \ for Tools make sure Show Text as is not set to All Text, or the selection will be too large        f o r   T o o l s   m a k e   s u r e   S h o w   T e x t   a s   i s   n o t   s e t   t o   A l l   T e x t ,   o r   t h e   s e l e c t i o n   w i l l   b e   t o o   l a r g e 
 l        
 I 
 .sysodelanull  nmbr
 m   ?ٙ   
 I )
 .prcskprsnull    utxt
 1  
 
tab  
 
faal
 J   % 
 m   #
 eMdsKopt     
 I */
 .sysodelanull  nmbr
 m  *+ ?ə   
 l 00       
 I 0?
 .prcskprsnull    utxt
 m  03   a 
 
faal
 J  6; 
 m  69
 eMdsKcmd     
 l @@       
 l @@   H B instead of command-a selecting all, can select a number of lines:        i n s t e a d   o f   c o m m a n d - a   s e l e c t i n g   a l l ,   c a n   s e l e c t   a   n u m b e r   o f   l i n e s : 
 l @@    repeat 5 times      r e p e a t   5   t i m e s 
 l @@   : 4	key code 125 using {shift down} -- shift down arrow     h 	 k e y   c o d e   1 2 5   u s i n g   { s h i f t   d o w n }   - -   s h i f t   d o w n   a r r o w 
 l @@    
end repeat      e n d   r e p e a t 
 l @@       
 I @E
 .sysodelanull  nmbr
 m  @A ?ə   
 l FF       
 l FU 
  I FU
 .prcskprsnull    utxt
 m  FI   c 
 
faal
 J  LQ 	
	 m  LO
 eMdsKcmd     $  add control down for citation    

 <   a d d   c o n t r o l   d o w n   f o r   c i t a t i o n 
 I V]
 .sysodelanull  nmbr

 m  VY ?ٙ   
 l ^^       
 Z  ^
 = ^c
 o  ^_ 0 
aotheroptions 
aOtherOptions
 m  _b   r e t u r n R e s u l t
 k  fv 
 l ff   U O return the copied results to the script or environment that called the handler        r e t u r n   t h e   c o p i e d   r e s u l t s   t o   t h e   s c r i p t   o r   e n v i r o n m e n t   t h a t   c a l l e d   t h e   h a n d l e r  
 l ff        !"
! r  fm#$
# I fk
 .JonsgClp****     null    
$ o       0 	theresult 	theResult" %&
% I ns'
 .sysodelanull  nmbr
' m  no(( ?ə  & )
) L  tv*
* o  tu 0 	theresult 	theResult   +,
+ = y~-.
- o  yz 0 
aotheroptions 
aOtherOptions
. m  z}// 00  p a s t e R e s u l t, 1
1 k  22 34
3 l       4 56
5 l 78  7 0 * paste the copied results in previous app    8 99 T   p a s t e   t h e   c o p i e d   r e s u l t s   i n   p r e v i o u s   a p p  6 :;
: I <=
 .prcskprsnull    utxt
< m  >> ??  h= @
 
faal
@ J  AA B
B m  
 eMdsKcmd    ; CD
C I E
 .sysodelanull  nmbr
E m  FF ?ə  D GH
G r  IJ
I I 
 .JonsgClp****     null    
J o       0 
asearchstring 
aSearchStringH KL
K O MN
M I  O 0 	pastetext 	pasteTextO PQ
P o   0 
asearchstring 
aSearchStringQ R
R o   0 	inputfrom 	inputFrom    
N  f  L S
S L  T
T m  
 boovtrue             U
U l         
 o     0 
accordprocess 
accordProcess V
V L  W
W m  
 boovtrue  
| m   g hXX                                                                                  sevs  alis      Macintosh HD               8H+  System Events.app                                              y          	                CoreServices    $            =Macintosh HD:System: Library: CoreServices: System Events.app   $  S y s t e m   E v e n t s . a p p    M a c i n t o s h   H D  -System/Library/CoreServices/System Events.app   /   z YZ
Y l       Z [\
[ l       \ ]
] l          ^_
^ l           _ `a
` l     bc  b + %-------------------------------------   c dd J - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -a ef
e l     gh  g   Utility Handlers --   h ii (   U t i l i t y   H a n d l e r s   - -f jk
j l     lm  l + %-------------------------------------   m nn J - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -k op
o l           p qr
q i   6 9st
s I      u .0 removeextracharacters removeExtraCharactersu v
v o       0 	thestring 	theString    
t k     dww xy
x l     ~z{~  z [ U removes all non-alphanumeric characters from the beginning and the end of the string   { ||    r e m o v e s   a l l   n o n - a l p h a n u m e r i c   c h a r a c t e r s   f r o m   t h e   b e g i n n i n g   a n d   t h e   e n d   o f   t h e   s t r i n gy }~
} l     }|{}  |  {  ~ 
 r     
 c     
 o     zz 0 	thestring 	theString
 m    y
y 
TEXT
 o      xx 0 	thestring 	theString 
 T    3
 k    . 
 Z    wv
 E   
 m      L a b c d e f g h i j k l m n o p q r s t u v w x y z 1 2 3 4 5 6 7 8 9 0 ( )
 l   ut
 n    
 7  
 s
s 
ctxt
 m    rr 
 m    qq 
 o    
pp 0 	thestring 	theStringu  t  
  S    w  v   o
 r   ! .
 n   ! ,
 7  " ,n
n 
ctxt
 m   & (mm 
 m   ) +ll
 o   ! "kk 0 	thestring 	theString
 o      jj 0 	thestring 	theStringo   
 T   4 a
 k   9 \ 
 Z  9 Nih
 E  9 F
 m   9 :  L a b c d e f g h i j k l m n o p q r s t u v w x y z 1 2 3 4 5 6 7 8 9 0 ( )
 n   : E
 7  ; Eg
g 
ctxt
 m   ? Aff
 m   B Dee
 o   : ;dd 0 	thestring 	theString
  S   I Ji  h   c
 r   O \
 n   O Z
 7  P Zb
b 
ctxt
 m   T Vaa 
 m   W Y``
 o   O P__ 0 	thestring 	theString
 o      ^^ 0 	thestring 	theStringc   ]
 L   b d
 o   b c\\ 0 	thestring 	theString]  r 
 l     [ZY[  Z  Y   
 i   : =
 I      XWX 0 	pastetext 	pasteText 
 o      VV 0 	thestring 	theString U
 o      TT 0 thescope theScopeU  W  
 k     p 
 l     SS   1 + can hard code to paste into a specific app     V   c a n   h a r d   c o d e   t o   p a s t e   i n t o   a   s p e c i f i c   a p p 
 l     RR   . ( tell application "TextEdit" to activate     P   t e l l   a p p l i c a t i o n   " T e x t E d i t "   t o   a c t i v a t e 
 l     QPOQ  P  O   
 l     NN   4 . Customizes result pasting for specific scopes     \   C u s t o m i z e s   r e s u l t   p a s t i n g   f o r   s p e c i f i c   s c o p e s M
 Z     p
 =    
 o     LL 0 thescope theScope
 m       L a u n c h B a r
 w    
 O   
 I   K
K .odlbactn****       ****
 m    
   C o p y   a n d   P a s t e JI
J 
ptxt
 o    HH 0 	thestring 	theStringI  
 m    	v                                                                                      @ alis       Macintosh HD               8H+  
LaunchBar.app                                                                A                 $               
 L a u n c h B a r . a p p    M a c i n t o s h   H D  Applications/LaunchBar.app  /       v                                                                                      @ alis       Macintosh HD               8H+  
LaunchBar.app                                                                A                 $               
 L a u n c h B a r . a p p    M a c i n t o s h   H D  Applications/LaunchBar.app  /        
 G    "
 E    
 o    GG 0 thescope theScope
 m       T e x t E d i t
 E     
 o    FF 0 thescope theScope
 m      
 P a g e s E
 k   % G 
 r   % ,
 I  % *DCB
D .JonsgClp****     nullC  B  
 o      AA 0 oldclipboard OldClipboard 
 I  - 9@?
@ .JonspClpnull     ****
 K   - 5 >
> 
ctxt
 l  . 1=<
 c   . 1
 o   . /;; 0 	thestring 	theString
 m   / 0:
: 
TEXT=  <   9 8
9 
utxt
  o   2 377 0 	thestring 	theString8  ?   
 l  : :66     Paste matching style     *   P a s t e   m a t c h i n g   s t y l e 
 I   : A545 $0 dokeycombination doKeyCombination 	

	 m   ; <   v
 
3

 m   < =   x o s3  4   2
 I  B G10
1 .JonspClpnull     ****
 o   B C// 0 oldclipboard OldClipboard0  2  E  
 k   J p 
 r   J Q
 I  J O.-,
. .JonsgClp****     null-  ,  
 o      ++ 0 oldclipboard OldClipboard 
 I  R ^*)
* .JonspClpnull     ****
 K   R Z (
( 
ctxt
 l  S V'&
 c   S V
 o   S T%% 0 	thestring 	theString
 m   T U$
$ 
TEXT'  &   # "
# 
utxt
  o   W X!! 0 	thestring 	theString"  )   !"
! I   _ j #  $0 dokeycombination doKeyCombination# $%
$ m   ` c&& ''  v% (
( m   c f)) **  x    " +
+ I  k p,
 .JonspClpnull     ****
, o   k l 0 oldclipboard OldClipboard    M   -.
- l           . /0
/ l           0 12
1 i   > A34
3 I      5 0 
displayresult 
displayResult5 6
6 o       0 	thestring 	theString    
4 k     I77 89
8 O     G:;
: Z    F<=>?
< I   @
 .coredoexbool       obj 
@ 4    
A

 
prcs
A m    BB CC  Q u i c k s i l v e r  
= k    DD EF
E w    GH
G O   IJ
I I   K
 .DAEDlargnull    utxt
K o    

 0 	thestring 	theString  
J m    LL                                                                                  daed  alis      Macintosh HD               8H+   0QQuicksilver.app                                                I@sR          	                Applications    $      s      0Q {    7Macintosh HD:Users: joew: Applications: Quicksilver.app      Q u i c k s i l v e r . a p p    M a c i n t o s h   H D  'Users/joew/Applications/Quicksilver.app   /      H                                                                                  daed  alis      Macintosh HD               8H+   0QQuicksilver.app                                                I@sR          	                Applications    $      s      0Q {    7Macintosh HD:Users: joew: Applications: Quicksilver.app      Q u i c k s i l v e r . a p p    M a c i n t o s h   H D  'Users/joew/Applications/Quicksilver.app   /      F M	
M l         	  > NO
N I    (P
 .coredoexbool       obj 
P 4     $Q
 
prcs
Q m   " #RR SS  L a u n c h B a r  O T
T k   + 9UU VW
V w   + 7XY
X O  - 7Z[
Z I  1 6\ 
 .odlbltyp****       ****
\ o   1 2 0 	thestring 	theString   
[ m   - .]]v                                                                                      @ alis       Macintosh HD               8H+  
LaunchBar.app                                                                A                 $               
 L a u n c h B a r . a p p    M a c i n t o s h   H D  Applications/LaunchBar.app  /       Yv                                                                                      @ alis       Macintosh HD               8H+  
LaunchBar.app                                                                A                 $               
 L a u n c h B a r . a p p    M a c i n t o s h   H D  Applications/LaunchBar.app  /       W ^_
^ l  8 8      _ `
` l   8 8ab  a 
			--Growl display disabled			
		else if exists process "GrowlHelperApp" then
			using terms from application "Growl.app"
			tell application "GrowlHelperApp.app"
				event register given class appl:"Accordance Script Library", full text:{"Accordance Result"}, class dnot:{"Accordance Result"}, class iapp:"Accordance"
				event notifygr given class name:"Accordance Result", title:"Accordance Result", description:theString, class appl:"Accordance Script Library" --with sticky
			end tell
			end
   b cc   
 	 	 	 - - G r o w l   d i s p l a y   d i s a b l e d 	 	 	 
 	 	 e l s e   i f   e x i s t s   p r o c e s s   " G r o w l H e l p e r A p p "   t h e n 
 	 	 	 u s i n g   t e r m s   f r o m   a p p l i c a t i o n   " G r o w l . a p p " 
 	 	 	 t e l l   a p p l i c a t i o n   " G r o w l H e l p e r A p p . a p p " 
 	 	 	 	  e v e n t   r e g i s t e r    g i v e n    c l a s s   a p p l  : " A c c o r d a n c e   S c r i p t   L i b r a r y " ,   f u l l   t e x t : { " A c c o r d a n c e   R e s u l t " } ,    c l a s s   d n o t  : { " A c c o r d a n c e   R e s u l t " } ,    c l a s s   i a p p  : " A c c o r d a n c e " 
 	 	 	 	  e v e n t   n o t i f y g r    g i v e n    c l a s s   n a m e  : " A c c o r d a n c e   R e s u l t " ,   t i t l e : " A c c o r d a n c e   R e s u l t " ,   d e s c r i p t i o n : t h e S t r i n g ,    c l a s s   a p p l  : " A c c o r d a n c e   S c r i p t   L i b r a r y "   - - w i t h   s t i c k y 
 	 	 	 e n d   t e l l 
 	 	 	 e n d 
    
? O  < Fde
d I  @ Ef
 .sysodlogaskr        ****
f o   @ A 0 	thestring 	theString  
e  f   < =
; m     gg                                                                                  sevs  alis      Macintosh HD               8H+  System Events.app                                              y          	                CoreServices    $            =Macintosh HD:System: Library: CoreServices: System Events.app   $  S y s t e m   E v e n t s . a p p    M a c i n t o s h   H D  -System/Library/CoreServices/System Events.app   /   9 h
h l  H H        2 ij
i l           j kl
k l           l mn
m i   B Eop
o I      q 0 
minimumvolume 
minimumVolumeq r
r o       0 n      
p k     #ss tu
t l     vw  v 6 0 sets volume to a minimal level (from 10 to 100)   w xx `   s e t s   v o l u m e   t o   a   m i n i m a l   l e v e l   ( f r o m   1 0   t o   1 0 0 )u yz
y r     	{|
{ n     }~
} 1    
 
ouvl
~ l    
 I    
 .sysogtvlvlst    null        
| o       0 	curvolume 	curVolumez 
 Z  
 
 A   
 

 o   
  0 	curvolume 	curVolume
 o     0 n  
 I   
 .aevtstvlnull  nmbr   
 
ouvl
 o     0 n         
 I   #
 .aevtstvlnull  nmbr   
 
mute
 m    
 boovfals    n 
 l            
 i   F I
 I       $0 dokeycombination doKeyCombination 
 o       0 thekeystroke theKeystroke 
 o       0 keymods keyMods    
 k      
 l        0 * keyMods can contain any or none of "xosc"     T   k e y M o d s   c a n   c o n t a i n   a n y   o r   n o n e   o f   " x o s c " 
 l        D > "x = ?, command; o = ?, option; s = ?, shift; c = ^, control"     |   " x   =  # ,   c o m m a n d ;   o   =  #% ,   o p t i o n ;   s   =  ! ,   s h i f t ;   c   =   ^ ,   c o n t r o l " 
 l        I C Warning: Sending the ^ control modifier is unreliable in some apps        W a r n i n g :   S e n d i n g   t h e   ^   c o n t r o l   m o d i f i e r   i s   u n r e l i a b l e   i n   s o m e   a p p s 
 l            
 O    
 r    
 c    
 l   
 n    
 1    
 
pnam
 l   
 6   
 2   
 
prcs
 =   
 1   	 
 
pisf
 m    
 boovtrue        
 m    
 
ctxt
 o       0 frontapp FrontApp
 m                                                                                       sevs  alis      Macintosh HD               8H+  System Events.app                                              y          	                CoreServices    $            =Macintosh HD:System: Library: CoreServices: System Events.app   $  S y s t e m   E v e n t s . a p p    M a c i n t o s h   H D  -System/Library/CoreServices/System Events.app   /    
 O    
 k     
 O    x
 k   # w 
 l  # #       
 r   # '
 J   # %  
 o       0 
keymodlist 
keyModList 
 Z  ( 9
 E   ( +
 o   ( ) 0 keymods keyMods
 m   ) *   x
 r   . 5
 b   . 3
 o   . / 0 
keymodlist 
keyModList
 J   / 2 
 m   / 0
 eMdsKcmd  
 o       0 
keymodlist 
keyModList     
 Z  : K
 E   : =
 o   : ; 0 keymods keyMods
 m   ; <   o
 r   @ G
 b   @ E
 o   @ A 0 
keymodlist 
keyModList
 J   A D 
 m   A B
 eMdsKopt  
 o       0 
keymodlist 
keyModList     
 Z  L ]
 E   L O
 o   L M 0 keymods keyMods
 m   M N   s
 r   R Y
 b   R W
 o   R S 0 
keymodlist 
keyModList
 J   S V 
 m   S T
 eMdsKsft  
 o       0 
keymodlist 
keyModList     
 Z  ^ o
 E   ^ a
 o   ^ _ 0 keymods keyMods
 m   _ `   c
 r   d k
 b   d i
 o   d e 0 
keymodlist 
keyModList
 J   e h 
 m   e f
 eMdsKctl  
 o       0 
keymodlist 
keyModList      
  I  p w
 .prcskprsnull    utxt
 o   p q 0 thekeystroke theKeystroke 
 
faal
 o   r s 0 
keymodlist 
keyModList    
 m                                                                                       sevs  alis      Macintosh HD               8H+  System Events.app                                              y          	                CoreServices    $            =Macintosh HD:System: Library: CoreServices: System Events.app   $  S y s t e m   E v e n t s . a p p    M a c i n t o s h   H D  -System/Library/CoreServices/System Events.app   /    
 I  y 
 .sysodelanull  nmbr
 m   y | ?333333    
 4    
 
capp
 o     0 frontapp FrontApp 	

	 l         
 
 l   
  
 ; 5 For special keys, use key code in place of keystroke     j   F o r   s p e c i a l   k e y s ,   u s e   k e y   c o d e   i n   p l a c e   o f   k e y s t r o k e 
 l        "left" = key code 123     ,   " l e f t "   =   k e y   c o d e   1 2 3 
 l        "right" = key code 124     .   " r i g h t "   =   k e y   c o d e   1 2 4 
 l        "down" = key code 125     ,   " d o w n "   =   k e y   c o d e   1 2 5  
 l   !"  !   "up" = key code 126   " ## (   " u p "   =   k e y   c o d e   1 2 6  $%
$ l   &'  &   "tab" = key code 48   ' (( (   " t a b "   =   k e y   c o d e   4 8% )*
) l   +,  +   "space" = key code 49   , -- ,   " s p a c e "   =   k e y   c o d e   4 9* ./
. l   01  0   "enter" = key code 76   1 22 ,   " e n t e r "   =   k e y   c o d e   7 6/ 34
3 l   56  5   "return" = key code 36 ?   6 77 2   " r e t u r n "   =   k e y   c o d e   3 6   ?4 89
8 l   :;  :    "backspace" = key code 51   ; << 4   " b a c k s p a c e "   =   k e y   c o d e   5 19 =>
= l   ?@  ?   "home" = key code 115   @ AA ,   " h o m e "   =   k e y   c o d e   1 1 5> BC
B l   DE  D   "end" = key code 119   E FF *   " e n d "   =   k e y   c o d e   1 1 9C GH
G l   ~IJ~  I   "insert" = key code 114   J KK 0   " i n s e r t "   =   k e y   c o d e   1 1 4H LM
L l   }NO}  N   "delete" = key code 117   O PP 0   " d e l e t e "   =   k e y   c o d e   1 1 7M QR
Q l   |ST|  S   "pgup" = key code 116   T UU ,   " p g u p "   =   k e y   c o d e   1 1 6R V{
V l   zWXz  W   "pgdn" = key code 121   X YY ,   " p g d n "   =   k e y   c o d e   1 2 1{   Z[
Z l     yxwy  x  w  [ \v
\ l     utsu  t  s  v  
 misccura  r] 5q K Wp m^_`abcdefghijkr  ] onmlkjihgfedcba`_^]\o 0 
moduletype 
moduleTypen 0 whichmodule whichModulem 0 	fieldtype 	fieldTypel 0 outputto outputTok &0 usecitationformat useCitationFormatj 0 otheroptions otherOptions
i .aevtoappnull      ****
h .DAEDopnt****       utxtg 0 
handle_string  f .0 getmodulenamefromlist getModuleNameFromListe 0 
getmodulelist 
getModuleListd $0 getscripturetext getScriptureTextc 0 checkenglish checkEnglishb $0 lookupaccordance lookupAccordancea $0 showinaccordance showInAccordance` .0 removeextracharacters removeExtraCharacters_ 0 	pastetext 	pasteText^ 0 
displayresult 
displayResult] 0 
minimumvolume 
minimumVolume\ $0 dokeycombination doKeyCombinationq 
p boovfals^ [ ZYlmX
[ .aevtoappnull      ****Z  Y  l  m  W VUTS RQPO
W 
dtxt
V .sysodlogaskr        ****
U 
rslt
T 
ttxtS 0 searchstring searchStringR 0 	inputfrom 	inputFromQ P $0 lookupaccordance lookupAccordanceO 0 	theresult 	theResultX =l O,EOEO*b   b  b  b  b  b  + 
EO_ NMLnoK
N .DAEDopnt****       utxtM 0 searchstring searchStringL  n JIJ 0 searchstring searchStringI 0 	inputfrom 	inputFromo HGH G $0 lookupaccordance lookupAccordanceK *EO*b   b  b  b  b  b  + ` F:EDpqCF 0 
handle_string  E BrB r  AA 0 searchstring searchStringD  p @?@ 0 searchstring searchString? 0 	inputfrom 	inputFromq BL>=<
> .GURLGURLnull     TEXT= < $0 lookupaccordance lookupAccordanceC 0EOj O*b   b  b  b  b  b  + a ;w:9st8; .0 getmodulenamefromlist getModuleNameFromList: 7u7 u  66 0 modulenumber moduleNumber9  s 5435 0 modulenumber moduleNumber4 0 
modulelist 
moduleList3 0 
modulename 
moduleNamet 2102 0 
getmodulelist 
getModuleList
1 
cobj0 .0 removeextracharacters removeExtraCharacters8 *j+  EO/EO)k+ EOb /.-vw,/ 0 
getmodulelist 
getModuleList.  -  v ++ 0 	theresult 	theResultw *
* .AccdVerL****       ****,  	*j EUOc )('xy&) $0 getscripturetext getScriptureText( %z% z  $#"$ 0 
modulename 
moduleName# 0 
textreference 
textReference"  0 citationformat citationFormat'  x ! ! 0 
modulename 
moduleName  0 
textreference 
textReference  0 citationformat citationFormat 0 	theresult 	theResulty 
 .AccdTxRf****       ****&  
mvj EUOd {| 0 checkenglish checkEnglish } }   0 
modulename 
moduleName  {  0 
modulename 
moduleName 0 	theresult 	theResult| 
 .AccdIsEg****       ****  kvj EUOe 
~ $0 lookupaccordance lookupAccordance    

	 0 
search_string 
search_String
 0 module_type module_Type 0 which_module which_Module 0 
field_type 
field_Type
 0 
input_from 
input_From	 0 	output_to 	output_To (0 use_citationformat use_CitationFormat 0 
other_options 
other_Options  ~ 	  0 
search_string 
search_String 0 module_type module_Type 0 which_module which_Module 0 
field_type 
field_Type 0 
input_from 
input_From 0 	output_to 	output_To  (0 use_citationformat use_CitationFormat 0 
other_options 
other_Options 0 	theresult 	theResult +
  $0 showinaccordance showInAccordance
 
rslt .0 removeextracharacters removeExtraCharacters
 
long .0 getmodulenamefromlist getModuleNameFromList    
 .AccdTxRf****       **** 0 	pastetext 	pasteText
 .JonspClpnull     ****
 .sysodelanull  nmbr 2 0 
minimumvolume 
minimumVolume
 
VOIC
 .sysottosnull     TEXT
 .DAEDlargnull    utxt
 .odlbltyp****       **** 0 
displayresult 
displayResult	 *+ OEY *k+ EO &EO*k+ EW X  hO 
mvj 
EUO  *l+ OeOPY   j Oj OeOPY a   ,*a k+ O a l W X  j OeOPY \a   Fa   a Za  j UY #a   a Za  j UY *k+ OeOPY a   Y hOPf ! $0 showinaccordance showInAccordance     0 
asearchstring 
aSearchString 0 amoduletype aModuleType 0 awhichmodule aWhichModule 0 
afieldtype 
aFieldType 0 
aotheroptions 
aOtherOptions    0 
asearchstring 
aSearchString 0 amoduletype aModuleType 0 awhichmodule aWhichModule 0 
afieldtype 
aFieldType 0 
aotheroptions 
aOtherOptions 0 
accordprocess 
accordProcess 0 	theresult 	theResult 0 	inputfrom 	inputFrom TEJSYtxX,GX]k 
-%4@c[/>
 
ctxt
 
bool    
 
long
 
TEXT
 .miscactvnull  null
 .sysodelanull  nmbr
 
prcs 
 
faal
 eMdsKcmd
 .prcskprsnull    utxt     	
 eMdsKctl
 
mbar
 
mbri
 
menE
 
menI
 .prcsclicuiel     uiel .0 removeextracharacters removeExtraCharacters
 
spac {
 .prcskcodnull    long
 
tab 
 
alis
 .aevtodocnull      alis
 
ret 
 eMdsKopt
 .JonsgClp****     null 0 	pastetext 	pasteText 8[\[Z\Zi2 
  &
 [\[Z\Zi2 & 
%EY hW X  hO 
&EW X  &EO *j UOj OS *a a /EW &X   *a a /EW X  *a a /EOa a a a a v סa   Pa a a kvl Oa j Olma a a  a !a "a #ja #v &a a $kvl Y hOPY 5*a %k/a &a '/a (k/a )a */a (k/a )/a (k/a )/j +OPOa ,  ")k+ -EOa .a a a $lvl OPY  a /  a 0a a a $lvl Y hOPYIa 1  _ 2j Oa 3j 4O_ 5j OPY%a 6  F*a %k/a &a 7/a (k/a )a 8/a (k/a )/j +Oa 9j Oa :a a kvl OPY ١a ;  P*a %k/a &a </a (k/a )a =/a (k/a )/a (k/a )/j +Oa 9j Oa >a a kvl OPY a ?  ,*a %k/a &a @/a (k/a )a A/a (k/a )/j +Y Qa B  a C *a D/j EUOPY 3*a %k/a &a F/a (k/a )a G/a (k/a )/a (k/a )/j +Oj Oj Oa j O_ Hj Oa j O_ Hj Oa Ia Ja Kmv a j O_ 5a a Lkvl Oj Oa Ma a kvl Oj Oa Na a kvl Oa j Oa O  *j PEOj OY ;a Q  2a Ra a kvl Oj O*j PEO) 	*l+ SUOeY hY hOPUOeUOPg t .0 removeextracharacters removeExtraCharacters     0 	thestring 	theString    0 	thestring 	theString 
 
TEXT
 
ctxt e&EO ,hZ[\[Zk\Zk2 Y hO[\[Zl\Zi2E[OYO ,hZ[\[Zi\Zi2 Y hO[\[Zk\Z2E[OYOh  0 	pastetext 	pasteText     0 	thestring 	theString 0 thescope theScope    0 	thestring 	theString 0 thescope theScope 0 oldclipboard OldClipboard &)
 
ptxt
 .odlbactn****       ****
 
bool
 .JonsgClp****     null
 
ctxt
 
TEXT
 
utxt 
 .JonspClpnull     **** $0 dokeycombination doKeyCombination q  Z 	l UY [
 & '*j EO&j 
O*l+ Oj 
Y (*j EO&j 
O*a a l+ Oj 
i 4 0 
displayresult 
displayResult     0 	thestring 	theString    0 	thestring 	theString 
gBHRY
 
prcs
 .coredoexbool       obj 
 .DAEDlargnull    utxt
 .odlbltyp****       ****
 .sysodlogaskr        **** J D*/j  Z j UOPY (*/j  Z j UOPY ) j 	UUOPj p 0 
minimumvolume 
minimumVolume     0 n      0 n   0 	curvolume 	curVolume 
 .sysogtvlvlst    null
 
ouvl
 .aevtstvlnull  nmbr
 
mute $*j  ,EO *l Y hO*fl k ~}|{~ $0 dokeycombination doKeyCombination} zz   yxy 0 thekeystroke theKeystrokex 0 keymods keyMods|   wvutw 0 thekeystroke theKeystrokev 0 keymods keyModsu 0 frontapp FrontAppt 0 
keymodlist 
keyModList srqponmlkjih
s 
prcs  
r 
pisf
q 
pnam
p 
ctxt
o 
capp
n eMdsKcmd
m eMdsKopt
l eMdsKsft
k eMdsKctl
j 
faal
i .prcskprsnull    utxt
h .sysodelanull  nmbr{  *-[,\Ze81,&EUO*/ c VjvEO kv%EY hO kv%EY hO kv%EY hO kv%EY hOl UOa j UOP ascr  
ޭ